/**
 * \file: svg_error.h
 *
 * contains definition of common error types
 *
 * \component: svg_common
 *
 * \author: C. Spetzler
 *
 * \copyright: (c) 2003 - 2011 ADIT Corporation
 *
 * This Software is under a dual license (MIT/GPL).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#ifndef SVG_ERROR_H
#define SVG_ERROR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "svg_typedef.h"

/* error definition */
typedef SVGInt32 GRL_error;
typedef GRL_error SVGError;

#define GRL_NO_ERROR               0
#define SVG_NO_ERROR               0

/*
 * Error start values for the different modules
 * Each module can have up to 99 different error types
 */
#define SVG_COMMON_ERROR        -100
#define SVG_RESOURCE_ERROR      -200
#define SVG_FONT_ERROR          -300
#define SVG_BITMAP_DEC_ERROR    -400
#define SVG_LAYER_ERROR         -500
#define SVG_RASTERIZER_ERROR    -600
#define SVG_VIDEO_ERROR         -700
#define SVG_ANIMATION_ERROR     -800
#define SVG_ASM_ERROR           -900
#define SVG_SCRDRV_ERROR        -1000

/* BEGIN ARRAY_DEFINE SVG_ERROR */

typedef enum {
	/* given parameter has a NULL value */
	SVG_POINTER_NULL = SVG_COMMON_ERROR,
	/* given parameter 'context' is not defined */
	SVG_CONTEXT_NULL,
	/* given parameter has an invalid value */
	SVG_INVALID_ENUM,
	/* value is invalid  */
	SVG_INVALID_VALUE,
	/* invalid operation e.g. the rendering surface has not been set yet */
	SVG_INVALID_OPERATION,
	/* it runs out of memory */
	SVG_OUT_OF_MEMORY,
	/* internal overflow of memory detected */
	SVG_MEMORY_OVERFLOW,
	/* resources are not initialized */
	SVG_NOT_INITIALIZED,
	/* timeout error */
	SVG_TIMEOUT_ERROR,
	/* not supported function */
	SVG_FUNCTION_NOT_SUPPORTED,
	/* acquired  value is not existent */
	SVG_NOT_EXISTENT,
	/* value is already registered/used */
	SVG_ALREADY_IN_USE,
	/* last eror to check if we are out of bounds (double defined) */
	SVG_COMMON_ERROR_END = -1
} TR_COMMON_ERROR;

/* END ARRAY_DEFINE */

#ifdef __cplusplus
}
#endif
#endif				/* SVG_ERROR_H */
